#ifndef _INC_FX
#define _INC_FX

//------------------------------------------------------------------------------------------------------------
// VSIN
//------------------------------------------------------------------------------------------------------------
#ifdef INGAME
  // ingame
  struct TVsInStd
  {
    float4 Pos : POSITION;
    float3 Normal : NORMAL;
    float4 Color : COLOR0;
    float2 TexCoord : TEXCOORD0;
  };

  #define UP y
  #define FORWARD z

#else

  // 3dsmax
  const bool RowMajor = true;
  const int texcoord0 : Texcoord 
  < int Texcoord = 0; int MapChannel = 0; bool ColorChannel = true; >;
  const int texcoord1 : Texcoord 
  < int Texcoord = 1; int MapChannel = 1; >;

  struct TVsInStd
  {
    float4 Pos : POSITION;
    float3 Normal : NORMAL;
    float4 Color : TEXCOORD0;
    float2 TexCoord : TEXCOORD1;
  };
  
  #define UP z
  #define FORWARD y

#endif

struct TVsInNoNormal
{
  float4 Pos : POSITION;
  float4 Color : COLOR0;
  float2 TexCoord : TEXCOORD0;
};

struct TVsInPosOnly
{
  float4 Pos : POSITION;
};

//------------------------------------------------------------------------------------------------------------
// VSOUT
//------------------------------------------------------------------------------------------------------------
struct TVsOutStd
{
  float4 Pos : POSITION;
  float4 Color: COLOR0;
  float2 TexCoord : TEXCOORD0;
};

struct TVsOutStdShadow
{
  float4 Pos : POSITION;
  float4 Color: COLOR0;
  float2 TexCoord : TEXCOORD0;
  float3 ShadowParams : TEXCOORD1;  
};

struct TPsInStdShadow
{
  float4 Color: COLOR0;
  float2 TexCoord : TEXCOORD0;
  float3 ShadowParams : TEXCOORD1;  
};

//------------------------------------------------------------------------------------------------------------
// PSIN
//------------------------------------------------------------------------------------------------------------
struct TPsInStd
{
  float4 Color: COLOR0;
  float2 TexCoord : TEXCOORD0;
};

//------------------------------------------------------------------------------------------------------------
struct TPsOut
{
  float4 Color : COLOR0;
};

//------------------------------------------------------------------------------------------------------------
// Matrixes
//------------------------------------------------------------------------------------------------------------
float4x4 WorldMatrix : WORLD;
float4x4 WorldViewMatrix : WORLDVIEW;
float4x4 WorldViewProjectionMatrix : WORLDVIEWPROJECTION;
float3 WorldCameraPos : WORLDCAMERAPOSITION;
float4x4 ViewInverseMatrix : VIEWI;
float4x4 ViewProjectionMatrix : VIEWPROJECTION;

const float GAME_PI = 3.1415926535;

#define FALSE             0
#define TRUE              1

#define ZERO              1
#define ONE               2
#define SRCCOLOR          3
#define INVSRCCOLOR       4
#define SRCALPHA          5
#define INVSRCALPHA       6
#define DESTALPHA         7
#define INVDESTALPHA      8
#define DESTCOLOR         9
#define INVDESTCOLOR     10
#define SRCALPHASAT      11
#define BOTHSRCALPHA     12
#define BOTHINVSRCALPHA  13
#define BLENDFACTOR      14
#define INVBLENDFACTOR   15

#define NONE              1
#define CW                2
#define CCW               3

//------------------------------------------------------------------------------------------------------------
// From: http://www.gamedev.net/community/forums/topic.asp?topic_id=442138
// CAN NOT ENCODE 1.0!!!
float4 EncodeFloat(float fDist)
{
  // encode (fDist is the normalized distance):
  const float4 bitSh  = float4(   256*256*256, 256*256,   256,         1);
  const float4 bitMsk = float4(   0,      1.0/256.0,    1.0/256.0,    1.0/256.0);

  float4 comp;
  comp  = fDist * bitSh;
  comp  = frac(comp);
  comp  -= comp.xxyz * bitMsk;
  return comp;
}

//------------------------------------------------------------------------------------------------------------
// From: http://www.gamedev.net/community/forums/topic.asp?topic_id=442138
float DecodeFloat(float4 vec)
{
  const float4 bitShifts = float4(1.0/(256.0*256.0*256.0), 1.0/(256.0*256.0), 1.0/256.0, 1);
  return dot(vec.xyzw , bitShifts);
}

//------------------------------------------------------------------------------------------------------------
// SHADOW
//------------------------------------------------------------------------------------------------------------
#if INGAME

texture ShadowTexture
<
  string name = "White.tga";
>;

sampler2D Sampler_ShadowTexture = sampler_state
{
  Texture = <ShadowTexture>;
  AddressU = Clamp;
  AddressV = Clamp;
  MinFilter = Point;
  MagFilter = Point;
  MipFilter = Point;
};

float4x4 ShadowLightMatrixInv;

//------------------------------------------------------------------------------------------------------------
float3 GetShadowParams(float4 WorldPos)
{
  float3 ShadowParams;
  float4 PosInLight = mul(WorldPos, ShadowLightMatrixInv);
  ShadowParams.xy = float2(PosInLight.x, PosInLight.y) * float2(0.5, -0.5) + float2(0.5, 0.5);
  ShadowParams.z = PosInLight.z;
  return ShadowParams;
}

//------------------------------------------------------------------------------------------------------------
#define ShadowMapSize 1024.f
#define ShadowMapUvStep (2.f / ShadowMapSize)
#define NUMTAPS 9
const float2 filterTaps[NUMTAPS] = {
  {ShadowMapUvStep * -0.326212, ShadowMapUvStep * -0.405805},
  {ShadowMapUvStep * -0.840144, ShadowMapUvStep * -0.073580},
  {ShadowMapUvStep * -0.695914, ShadowMapUvStep * +0.457137},
  {ShadowMapUvStep * -0.203345, ShadowMapUvStep * +0.620716},
  {ShadowMapUvStep * +0.962340, ShadowMapUvStep * -0.194983},
  {ShadowMapUvStep * +0.473434, ShadowMapUvStep * -0.480026},
  {ShadowMapUvStep * +0.519456, ShadowMapUvStep * +0.767022},
  {ShadowMapUvStep * +0.185461, ShadowMapUvStep * -0.893124},
  {ShadowMapUvStep * +0.507431, ShadowMapUvStep * +0.064425},
};
 
//------------------------------------------------------------------------------------------------------------
float GetShadow(float3 ShadowMapParams, float Bias=0.007f)
{
  float2 uv = ShadowMapParams.xy;
  float DepthInLight = ShadowMapParams.z;
  float e = 0;
  for (int i=0; i<NUMTAPS; i++)
  {
    e += step(DecodeFloat(tex2D(Sampler_ShadowTexture, uv + filterTaps[i])) + Bias, DepthInLight);
  }
  e /= NUMTAPS;
  return e;
}

//------------------------------------------------------------------------------------------------------------
float GetShadowFast(float3 ShadowMapParams, float Bias=0.007f)
{
  float2 uv = ShadowMapParams.xy;
  float DepthInLight = ShadowMapParams.z;
  float e = 0;
  for (int i=0; i<4; i++)
  {
    e += step(DecodeFloat(tex2D(Sampler_ShadowTexture, uv + filterTaps[i])) + Bias, DepthInLight);
  }
  e /= 4;
  return e;
}

//------------------------------------------------------------------------------------------------------------
#else // #ifdef INGAME
// Do nothing in 3dsmax
float3 GetShadowParams(float4 WorldPos) { return float3(0,0,0); }
float GetShadow(float3 ShadowMapParams, float Bias=0.005f) { return 0.f; }
float GetShadowFast(float3 ShadowMapParams, float Bias=0.005f) { return 0.f; }

#endif // #ifdef INGAME

//------------------------------------------------------------------------------------------------------------
// COMMON FUNCS
//------------------------------------------------------------------------------------------------------------

float GetInvSqr(float x) { return 1 - (1-x) * (1-x); }

float GetSqr(float x) { return x*x; }


#endif


/*
float3 AmbientLight = float3(0.5f,0.5f,0.5f);

void SolveVertexLight(
  in float4 WorldPos, in float3 WorldNormal, 
  out float3 DirectLight, out float3 ShadowParams
) {
  float3 LightColor = float3(1,1,1);
  
  DirectLight = saturate(WorldNormal.y)*LightColor;
  ShadowParams = GetShadowParams(WorldPos);
}

float4 SolvePixelLight(
  in float4 DiffuseColor,
  in float3 DirectLight, in float3 ShadowParams
) {
  float Shadow = GetShadow(ShadowParams);
  float3 Light = saturate(Shadow * DirectLight + AmbientLight);
  return float4(Light,1) * DiffuseColor;
}
*/

//------------------------------------------------------------------------------------------------------------
const float4 Color : DIFFUSE
<
  string UIName = "Color";
> = { 1, 0, 0, 1 };

//------------------------------------------------------------------------------------------------------------
struct TVsOutCustom
{
  float4 Pos : POSITION;
};

TVsOutCustom VsMain(TVsInPosOnly IN)
{
  TVsOutCustom OUT;
  OUT.Pos = mul(IN.Pos, WorldViewProjectionMatrix);
  return OUT;
}

//------------------------------------------------------------------------------------------------------------
float4 PsMain() : COLOR0
{
  return Color;
}

//------------------------------------------------------------------------------------------------------------
technique Default
{
  pass p0
  {
    VertexShader = compile vs_2_0 VsMain();
    PixelShader  = compile ps_2_0 PsMain();
    FILLMODE = WireFrame;
  }
}

