#define SCENE_FOG 1
#define SCENE_RIM 0
//#define SCENE_SHADOW 0
#define SCENE_SHADOW_FUNC GetShadowFast
#define SCENE_TEX0_FILTER Point
#define SCENE_TEX1
#define SCENE_TEX1_FILTER Linear
#define SCENE_WORLDPOS



#ifndef _INC_FX
#define _INC_FX

//------------------------------------------------------------------------------------------------------------
// VSIN
//------------------------------------------------------------------------------------------------------------
#ifdef INGAME
  // ingame
  struct TVsInStd
  {
    float4 Pos : POSITION;
    float3 Normal : NORMAL;
    float4 Color : COLOR0;
    float2 TexCoord : TEXCOORD0;
  };

  #define UP y
  #define FORWARD z

#else

  // 3dsmax
  const bool RowMajor = true;
  const int texcoord0 : Texcoord 
  < int Texcoord = 0; int MapChannel = 0; bool ColorChannel = true; >;
  const int texcoord1 : Texcoord 
  < int Texcoord = 1; int MapChannel = 1; >;

  struct TVsInStd
  {
    float4 Pos : POSITION;
    float3 Normal : NORMAL;
    float4 Color : TEXCOORD0;
    float2 TexCoord : TEXCOORD1;
  };
  
  #define UP z
  #define FORWARD y

#endif

struct TVsInNoNormal
{
  float4 Pos : POSITION;
  float4 Color : COLOR0;
  float2 TexCoord : TEXCOORD0;
};

struct TVsInPosOnly
{
  float4 Pos : POSITION;
};

//------------------------------------------------------------------------------------------------------------
// VSOUT
//------------------------------------------------------------------------------------------------------------
struct TVsOutStd
{
  float4 Pos : POSITION;
  float4 Color: COLOR0;
  float2 TexCoord : TEXCOORD0;
};

struct TVsOutStdShadow
{
  float4 Pos : POSITION;
  float4 Color: COLOR0;
  float2 TexCoord : TEXCOORD0;
  float3 ShadowParams : TEXCOORD1;  
};

struct TPsInStdShadow
{
  float4 Color: COLOR0;
  float2 TexCoord : TEXCOORD0;
  float3 ShadowParams : TEXCOORD1;  
};

//------------------------------------------------------------------------------------------------------------
// PSIN
//------------------------------------------------------------------------------------------------------------
struct TPsInStd
{
  float4 Color: COLOR0;
  float2 TexCoord : TEXCOORD0;
};

//------------------------------------------------------------------------------------------------------------
struct TPsOut
{
  float4 Color : COLOR0;
};

//------------------------------------------------------------------------------------------------------------
// Matrixes
//------------------------------------------------------------------------------------------------------------
float4x4 WorldMatrix : WORLD;
float4x4 WorldViewMatrix : WORLDVIEW;
float4x4 WorldViewProjectionMatrix : WORLDVIEWPROJECTION;
float3 WorldCameraPos : WORLDCAMERAPOSITION;
float4x4 ViewInverseMatrix : VIEWI;
float4x4 ViewProjectionMatrix : VIEWPROJECTION;

const float GAME_PI = 3.1415926535;

#define FALSE             0
#define TRUE              1

#define ZERO              1
#define ONE               2
#define SRCCOLOR          3
#define INVSRCCOLOR       4
#define SRCALPHA          5
#define INVSRCALPHA       6
#define DESTALPHA         7
#define INVDESTALPHA      8
#define DESTCOLOR         9
#define INVDESTCOLOR     10
#define SRCALPHASAT      11
#define BOTHSRCALPHA     12
#define BOTHINVSRCALPHA  13
#define BLENDFACTOR      14
#define INVBLENDFACTOR   15

#define NONE              1
#define CW                2
#define CCW               3

//------------------------------------------------------------------------------------------------------------
// From: http://www.gamedev.net/community/forums/topic.asp?topic_id=442138
// CAN NOT ENCODE 1.0!!!
float4 EncodeFloat(float fDist)
{
  // encode (fDist is the normalized distance):
  const float4 bitSh  = float4(   256*256*256, 256*256,   256,         1);
  const float4 bitMsk = float4(   0,      1.0/256.0,    1.0/256.0,    1.0/256.0);

  float4 comp;
  comp  = fDist * bitSh;
  comp  = frac(comp);
  comp  -= comp.xxyz * bitMsk;
  return comp;
}

//------------------------------------------------------------------------------------------------------------
// From: http://www.gamedev.net/community/forums/topic.asp?topic_id=442138
float DecodeFloat(float4 vec)
{
  const float4 bitShifts = float4(1.0/(256.0*256.0*256.0), 1.0/(256.0*256.0), 1.0/256.0, 1);
  return dot(vec.xyzw , bitShifts);
}

//------------------------------------------------------------------------------------------------------------
// SHADOW
//------------------------------------------------------------------------------------------------------------
#if INGAME

texture ShadowTexture
<
  string name = "White.tga";
>;

sampler2D Sampler_ShadowTexture = sampler_state
{
  Texture = <ShadowTexture>;
  AddressU = Clamp;
  AddressV = Clamp;
  MinFilter = Point;
  MagFilter = Point;
  MipFilter = Point;
};

float4x4 ShadowLightMatrixInv;

//------------------------------------------------------------------------------------------------------------
float3 GetShadowParams(float4 WorldPos)
{
  float3 ShadowParams;
  float4 PosInLight = mul(WorldPos, ShadowLightMatrixInv);
  ShadowParams.xy = float2(PosInLight.x, PosInLight.y) * float2(0.5, -0.5) + float2(0.5, 0.5);
  ShadowParams.z = PosInLight.z;
  return ShadowParams;
}

//------------------------------------------------------------------------------------------------------------
#define ShadowMapSize 1024.f
#define ShadowMapUvStep (2.f / ShadowMapSize)
#define NUMTAPS 9
const float2 filterTaps[NUMTAPS] = {
  {ShadowMapUvStep * -0.326212, ShadowMapUvStep * -0.405805},
  {ShadowMapUvStep * -0.840144, ShadowMapUvStep * -0.073580},
  {ShadowMapUvStep * -0.695914, ShadowMapUvStep * +0.457137},
  {ShadowMapUvStep * -0.203345, ShadowMapUvStep * +0.620716},
  {ShadowMapUvStep * +0.962340, ShadowMapUvStep * -0.194983},
  {ShadowMapUvStep * +0.473434, ShadowMapUvStep * -0.480026},
  {ShadowMapUvStep * +0.519456, ShadowMapUvStep * +0.767022},
  {ShadowMapUvStep * +0.185461, ShadowMapUvStep * -0.893124},
  {ShadowMapUvStep * +0.507431, ShadowMapUvStep * +0.064425},
};
 
//------------------------------------------------------------------------------------------------------------
float GetShadow(float3 ShadowMapParams, float Bias=0.007f)
{
  float2 uv = ShadowMapParams.xy;
  float DepthInLight = ShadowMapParams.z;
  float e = 0;
  for (int i=0; i<NUMTAPS; i++)
  {
    e += step(DecodeFloat(tex2D(Sampler_ShadowTexture, uv + filterTaps[i])) + Bias, DepthInLight);
  }
  e /= NUMTAPS;
  return e;
}

//------------------------------------------------------------------------------------------------------------
float GetShadowFast(float3 ShadowMapParams, float Bias=0.007f)
{
  float2 uv = ShadowMapParams.xy;
  float DepthInLight = ShadowMapParams.z;
  float e = 0;
  for (int i=0; i<4; i++)
  {
    e += step(DecodeFloat(tex2D(Sampler_ShadowTexture, uv + filterTaps[i])) + Bias, DepthInLight);
  }
  e /= 4;
  return e;
}

//------------------------------------------------------------------------------------------------------------
#else // #ifdef INGAME
// Do nothing in 3dsmax
float3 GetShadowParams(float4 WorldPos) { return float3(0,0,0); }
float GetShadow(float3 ShadowMapParams, float Bias=0.005f) { return 0.f; }
float GetShadowFast(float3 ShadowMapParams, float Bias=0.005f) { return 0.f; }

#endif // #ifdef INGAME

//------------------------------------------------------------------------------------------------------------
// COMMON FUNCS
//------------------------------------------------------------------------------------------------------------

float GetInvSqr(float x) { return 1 - (1-x) * (1-x); }

float GetSqr(float x) { return x*x; }


#endif


/*
float3 AmbientLight = float3(0.5f,0.5f,0.5f);

void SolveVertexLight(
  in float4 WorldPos, in float3 WorldNormal, 
  out float3 DirectLight, out float3 ShadowParams
) {
  float3 LightColor = float3(1,1,1);
  
  DirectLight = saturate(WorldNormal.y)*LightColor;
  ShadowParams = GetShadowParams(WorldPos);
}

float4 SolvePixelLight(
  in float4 DiffuseColor,
  in float3 DirectLight, in float3 ShadowParams
) {
  float Shadow = GetShadow(ShadowParams);
  float3 Light = saturate(Shadow * DirectLight + AmbientLight);
  return float4(Light,1) * DiffuseColor;
}
*/

#ifdef INGAME
  #define UV xz
#else
  #define UV xy
#endif

#define Rot45Angle 0.78539816339744830961566084581988

const float2x2 Rot45Matrix = 
{
  { cos(Rot45Angle), -sin(Rot45Angle) },
  { sin(Rot45Angle), cos(Rot45Angle) }
};

//------------------------------------------------------------------------------------------------------------
float2 GetGroundTexCoord(float3 WorldPos)
{
  float2 uv = (WorldPos.UV  / 100.f) + float2(1,1) * 0.5f;
  uv = mul(uv, Rot45Matrix);
  return uv;
}

//------------------------------------------------------------------------------------------------------------
float2 GetSoftShadowTexCoord(float3 WorldPos)
{
  float2 SoftShadowTexCoord = (WorldPos.UV / 180.f) + float2(1,1) * 0.5f;
  SoftShadowTexCoord.y = 1-SoftShadowTexCoord.y;
  SoftShadowTexCoord.y += 0.001f;
  SoftShadowTexCoord.x += 0.001f;
  return SoftShadowTexCoord;
}

//------------------------------------------------------------------------------------------------------------
float GetFog(float3 WorldPos)
{
  float Fog = saturate(length(WorldPos.xyz - WorldCameraPos) / 400);
  Fog = pow(Fog, 2);
  return Fog;
}

//------------------------------------------------------------------------------------------------------------
const float3 SkyLight = float3(0.9,0.9,0.95);
const float3 GroundLight = float3(0.45, 0.45, 0.5);//.5, 0.25, 0.25);
const float3 ShadowLight = float3(0.45, 0.45, 0.5);
//const float3 FogColor = float3(0.55,0.35,0.25);
const float3 FogColor = float3(0.65,0.45,0.35);
//const float3 FogColor = float3(0.718,1,1);
//const float3 FogColor = float3(0.8, 0.75,1);
//const float3 FogColor = float3(0.55,0.35,0.45);
//const float3 FogColor = float3(0.5,0.55,0.6);

// 0.9, 1, 1
// .187, .569, 1
// .094, 0.49, 1
const float3 MaxHeightColor = float3(0.85f, 0.8f, 0.7f);


#ifndef SCENE_SHADOW
  #define SCENE_SHADOW 1
#endif
#ifndef SCENE_RIM
  #define SCENE_RIM 1
#endif
#ifndef SCENE_FOG
  #define SCENE_FOG 1
#endif

#ifndef SCENE_SHADOW_BIAS
  #define SCENE_SHADOW_BIAS 0.005f
#endif
#ifndef SCENE_SHADOW_FUNC
  #define SCENE_SHADOW_FUNC GetShadow
#endif
#ifndef SCENE_TEX0_FILTER
  #define SCENE_TEX0_FILTER Point
#endif
#ifndef SCENE_TEX1_FILTER
  #define SCENE_TEX1_FILTER Linear
#endif

#ifdef INGAME
  #define UP y
  #define FORWARD z
#else
  #define UP z
  #define FORWARD y
  // no fog in 3dsmax
  #define SCENE_FOG 0
  // no shadows in 3dsmax
  #define SCENE_SHADOW 0
#endif

//------------------------------------------------------------------------------------------------------------
texture Tex0 : DiffuseMap
<
  string name = "White.tga";
  int MapChannel = 1;
  string UIName = "Diffuse";
>;

sampler2D Sampler_Tex0 = sampler_state
{
  Texture = <Tex0>;
  MinFilter = SCENE_TEX0_FILTER;
  MagFilter = SCENE_TEX0_FILTER;
  MipFilter = SCENE_TEX0_FILTER;
};

//------------------------------------------------------------------------------------------------------------
struct TVsOutCustom
{
  float4 Pos : POSITION;
  float4 Color: COLOR0;
  float3 TexCoordAndFog : TEXCOORD0;
  float3 ShadowParams : TEXCOORD1;  
  float3 WorldNormal : TEXCOORD2;
  float3 WorldPos : TEXCOORD3;
};

struct TPsInCustom
{
  //float4 Pos : POSITION;
  float4 Color: COLOR0;
  float3 TexCoordAndFog : TEXCOORD0;
  float3 ShadowParams : TEXCOORD1;  
  float3 WorldNormal : TEXCOORD2;
  float3 WorldPos : TEXCOORD3;
};

//------------------------------------------------------------------------------------------------------------
TVsOutCustom VsMain(TVsInStd IN)
{
  TVsOutCustom OUT;
  
  float4 InPos = IN.Pos;

  OUT.Pos = mul(InPos, WorldViewProjectionMatrix);
  OUT.TexCoordAndFog.xy = IN.TexCoord;
  OUT.Color = IN.Color;
  
  float4 WorldPos = mul(InPos, WorldMatrix);
  OUT.ShadowParams = GetShadowParams(WorldPos);
  
  float3 WorldNormal = mul(IN.Normal, (float3x3)WorldMatrix);
  OUT.WorldNormal = WorldNormal;
 
  OUT.WorldPos = WorldPos.xyz;
  OUT.TexCoordAndFog.z = GetFog(WorldPos.xyz);

  return OUT;
}

//------------------------------------------------------------------------------------------------------------
float4 PsMain(TPsInCustom IN) : COLOR0
{
  float4 TexColor = tex2D(Sampler_Tex0, IN.TexCoordAndFog.xy);
  
  float3 WorldToCam = normalize(WorldCameraPos - IN.WorldPos.xyz);  
  float Rim = saturate(1-dot(normalize(IN.WorldNormal), WorldToCam));
  Rim *= 1 - abs(IN.WorldNormal.UP);
  Rim = pow(Rim, 2.f);
  
  float4 Color = IN.Color * TexColor;
  
  Color.xyz *= lerp(SkyLight, ShadowLight, SCENE_SHADOW_FUNC(IN.ShadowParams, SCENE_SHADOW_BIAS) * 0.75f);
  Color.xyz += Rim * float3(0.6, 0.5, 0.4);
  Color.xyz *= saturate(0.25f + (IN.WorldPos.UP * 0.1f) + IN.WorldNormal.UP);
 
  //Color.xya
  Color.xyz = lerp(Color.xyz, FogColor, IN.TexCoordAndFog.z);
  
  Color.a = 1;
//#endif

//#ifdef SCENE_COLOR_EQ_FINAL
  //Color = SCENE_COLOR_EQ_FINAL;
//#endif

  return Color;
}

//------------------------------------------------------------------------------------------------------------
technique Default
{
  pass p0
  {
    VertexShader = compile vs_2_0 VsMain();
    PixelShader  = compile ps_2_0 PsMain();
  }
}



/*
//------------------------------------------------------------------------------------------------------------
//const float4 BlendColor = float4(0.15, 0.15, 0.15, 1);

#define TexColorAdd InColor.x*InColor.x
#define TexColorMult InColor.y
#define TexColorDrawnTextureMix InColor.z

float4 PlatformAdjust
<
  string UIName = "PlatformAdjust";
> = float4(0,0,0,0);

float4 GetPlatformColor(float4 TextureColor, float4 InColor)
{
  float add = TexColorAdd * (1-PlatformAdjust.x);
  float mult = saturate(TexColorMult + PlatformAdjust.x);
  return ((TextureColor + float4(add, add, add, 0)) * float4(mult, mult, mult, 1));
  //return TextureColor;
}

float4 GetTextureColor(sampler2D Sampler_Tex0, sampler2D Sampler_Tex1, float2 TexCoord, float4 InColor)
{
  //return tex2D(Sampler_Tex0, TexCoord);
  float2 TexCoord2 = TexCoord * float2(512.f/400.f, 512.f/480.f);
  return tex2D(Sampler_Tex0, TexCoord) * lerp(1, tex2D(Sampler_Tex1, TexCoord * float2(512.f/400.f, 512.f/480.f)).x, saturate(TexColorDrawnTextureMix - PlatformAdjust.x));
}

float4 GetTextureColor2(float3 WorldPos, sampler2D Sampler_Tex0, float2 TexCoord)
{
  //return tex2D(Sampler_Tex0, TexCoord);
  //float2 TexCoord2 = TexCoord * float2(512.f/400.f, 512.f/480.f);
  //return tex2D(Sampler_Tex0, TexCoord) * lerp(1, tex2D(Sampler_Tex1, TexCoord * float2(512.f/400.f, 512.f/480.f)).x, saturate(TexColorDrawnTextureMix - PlatformAdjust.x));
  float4 SketchColor = tex2D(Sampler_Tex0, TexCoord);
  //Color = lerp(Color, 1, saturate(TexColorDrawnTextureMix - PlatformAdjust.x));
  
  float4 HeightColor = lerp(float4(1,1,1,1), float4(0.5, 0.45, 0.2,1), saturate(WorldPos.y / 60));
  
  return SketchColor * HeightColor;
}

//float4 AdjustInPos(float4 InPos, float3 InNormal)
//{
//  InPos.y = lerp(max(0, InPos.y + PlatformAdjust.y) + 0.01f, InPos.y, step(InPos.y,0));
//  return InPos;
  //return mul(InPos.xyz, WorldViewProjectionMatrix);
//}

//#define SCENE_INPOS AdjustInPos(IN.Pos, IN.Normal)
//#define SCENE_COLOR_EQ GetTextureColor(Sampler_Tex0, Sampler_Tex1, IN.TexCoord, IN.Color)
#define SCENE_COLOR_EQ GetTextureColor2(IN.WorldPos, Sampler_Tex0, Sampler_Tex1, IN.TexCoord)
#define SCENE_COLOR_EQ_FINAL GetPlatformColor(Color, IN.Color)

include "scene.fx"
*/
