#include "_inc.fx"

//------------------------------------------------------------------------------------------------------------
texture Tex0 : DiffuseMap
<
  string name = "White.tga";
  int MapChannel = 1;
  string UIName = "Diffuse";
>;

sampler2D Sampler_Tex0 = sampler_state
{
  Texture = <Tex0>;
  MinFilter = Linear;
  MagFilter = Linear;
  MipFilter = Linear;
};

//------------------------------------------------------------------------------------------------------------
TVsOutStdShadow VsMain(TVsInStd IN)
{
  TVsOutStdShadow OUT;
  OUT.Pos = mul(IN.Pos, WorldViewProjectionMatrix);
  OUT.TexCoord = IN.TexCoord;
  OUT.Color = IN.Color;
  OUT.ShadowParams = GetShadowParams(mul(IN.Pos, WorldMatrix));
  return OUT;
}

//------------------------------------------------------------------------------------------------------------
float4 PsMain(TPsInStdShadow IN) : COLOR0
{
  return IN.Color * tex2D(Sampler_Tex0, IN.TexCoord) * GetShadow(IN.ShadowParams);  
}

//------------------------------------------------------------------------------------------------------------
technique Default
{
  pass p0
  {
    VertexShader = compile vs_2_0 VsMain();
    PixelShader  = compile ps_2_0 PsMain();
  }
}
