#ifndef _INC_FX
#define _INC_FX

//------------------------------------------------------------------------------------------------------------
// VSIN
//------------------------------------------------------------------------------------------------------------
#ifdef INGAME
  // ingame
  struct TVsInStd
  {
    float4 Pos : POSITION;
    float3 Normal : NORMAL;
    float4 Color : COLOR0;
    float2 TexCoord : TEXCOORD0;
  };

  #define UP y
  #define FORWARD z

#else

  // 3dsmax
  const bool RowMajor = true;
  const int texcoord0 : Texcoord 
  < int Texcoord = 0; int MapChannel = 0; bool ColorChannel = true; >;
  const int texcoord1 : Texcoord 
  < int Texcoord = 1; int MapChannel = 1; >;

  struct TVsInStd
  {
    float4 Pos : POSITION;
    float3 Normal : NORMAL;
    float4 Color : TEXCOORD0;
    float2 TexCoord : TEXCOORD1;
  };
  
  #define UP z
  #define FORWARD y

#endif

struct TVsInNoNormal
{
  float4 Pos : POSITION;
  float4 Color : COLOR0;
  float2 TexCoord : TEXCOORD0;
};

struct TVsInPosOnly
{
  float4 Pos : POSITION;
};

//------------------------------------------------------------------------------------------------------------
// VSOUT
//------------------------------------------------------------------------------------------------------------
struct TVsOutStd
{
  float4 Pos : POSITION;
  float4 Color: COLOR0;
  float2 TexCoord : TEXCOORD0;
};

struct TVsOutStdShadow
{
  float4 Pos : POSITION;
  float4 Color: COLOR0;
  float2 TexCoord : TEXCOORD0;
  float3 ShadowParams : TEXCOORD1;  
};

struct TPsInStdShadow
{
  float4 Color: COLOR0;
  float2 TexCoord : TEXCOORD0;
  float3 ShadowParams : TEXCOORD1;  
};

//------------------------------------------------------------------------------------------------------------
// PSIN
//------------------------------------------------------------------------------------------------------------
struct TPsInStd
{
  float4 Color: COLOR0;
  float2 TexCoord : TEXCOORD0;
};

//------------------------------------------------------------------------------------------------------------
struct TPsOut
{
  float4 Color : COLOR0;
};

//------------------------------------------------------------------------------------------------------------
// Matrixes
//------------------------------------------------------------------------------------------------------------
float4x4 WorldMatrix : WORLD;
float4x4 WorldViewMatrix : WORLDVIEW;
float4x4 WorldViewProjectionMatrix : WORLDVIEWPROJECTION;
float3 WorldCameraPos : WORLDCAMERAPOSITION;
float4x4 ViewInverseMatrix : VIEWI;
float4x4 ViewProjectionMatrix : VIEWPROJECTION;

const float GAME_PI = 3.1415926535;

#define FALSE             0
#define TRUE              1

#define ZERO              1
#define ONE               2
#define SRCCOLOR          3
#define INVSRCCOLOR       4
#define SRCALPHA          5
#define INVSRCALPHA       6
#define DESTALPHA         7
#define INVDESTALPHA      8
#define DESTCOLOR         9
#define INVDESTCOLOR     10
#define SRCALPHASAT      11
#define BOTHSRCALPHA     12
#define BOTHINVSRCALPHA  13
#define BLENDFACTOR      14
#define INVBLENDFACTOR   15

#define NONE              1
#define CW                2
#define CCW               3

//------------------------------------------------------------------------------------------------------------
// From: http://www.gamedev.net/community/forums/topic.asp?topic_id=442138
// CAN NOT ENCODE 1.0!!!
float4 EncodeFloat(float fDist)
{
  // encode (fDist is the normalized distance):
  const float4 bitSh  = float4(   256*256*256, 256*256,   256,         1);
  const float4 bitMsk = float4(   0,      1.0/256.0,    1.0/256.0,    1.0/256.0);

  float4 comp;
  comp  = fDist * bitSh;
  comp  = frac(comp);
  comp  -= comp.xxyz * bitMsk;
  return comp;
}

//------------------------------------------------------------------------------------------------------------
// From: http://www.gamedev.net/community/forums/topic.asp?topic_id=442138
float DecodeFloat(float4 vec)
{
  const float4 bitShifts = float4(1.0/(256.0*256.0*256.0), 1.0/(256.0*256.0), 1.0/256.0, 1);
  return dot(vec.xyzw , bitShifts);
}

//------------------------------------------------------------------------------------------------------------
// SHADOW
//------------------------------------------------------------------------------------------------------------
#if INGAME

texture ShadowTexture
<
  string name = "White.tga";
>;

sampler2D Sampler_ShadowTexture = sampler_state
{
  Texture = <ShadowTexture>;
  AddressU = Clamp;
  AddressV = Clamp;
  MinFilter = Point;
  MagFilter = Point;
  MipFilter = Point;
};

float4x4 ShadowLightMatrixInv;

//------------------------------------------------------------------------------------------------------------
float3 GetShadowParams(float4 WorldPos)
{
  float3 ShadowParams;
  float4 PosInLight = mul(WorldPos, ShadowLightMatrixInv);
  ShadowParams.xy = float2(PosInLight.x, PosInLight.y) * float2(0.5, -0.5) + float2(0.5, 0.5);
  ShadowParams.z = PosInLight.z;
  return ShadowParams;
}

//------------------------------------------------------------------------------------------------------------
#define ShadowMapSize 1024.f
#define ShadowMapUvStep (2.f / ShadowMapSize)
#define NUMTAPS 9
const float2 filterTaps[NUMTAPS] = {
  {ShadowMapUvStep * -0.326212, ShadowMapUvStep * -0.405805},
  {ShadowMapUvStep * -0.840144, ShadowMapUvStep * -0.073580},
  {ShadowMapUvStep * -0.695914, ShadowMapUvStep * +0.457137},
  {ShadowMapUvStep * -0.203345, ShadowMapUvStep * +0.620716},
  {ShadowMapUvStep * +0.962340, ShadowMapUvStep * -0.194983},
  {ShadowMapUvStep * +0.473434, ShadowMapUvStep * -0.480026},
  {ShadowMapUvStep * +0.519456, ShadowMapUvStep * +0.767022},
  {ShadowMapUvStep * +0.185461, ShadowMapUvStep * -0.893124},
  {ShadowMapUvStep * +0.507431, ShadowMapUvStep * +0.064425},
};
 
//------------------------------------------------------------------------------------------------------------
float GetShadow(float3 ShadowMapParams, float Bias=0.007f)
{
  float2 uv = ShadowMapParams.xy;
  float DepthInLight = ShadowMapParams.z;
  float e = 0;
  for (int i=0; i<NUMTAPS; i++)
  {
    e += step(DecodeFloat(tex2D(Sampler_ShadowTexture, uv + filterTaps[i])) + Bias, DepthInLight);
  }
  e /= NUMTAPS;
  return e;
}

//------------------------------------------------------------------------------------------------------------
float GetShadowFast(float3 ShadowMapParams, float Bias=0.007f)
{
  float2 uv = ShadowMapParams.xy;
  float DepthInLight = ShadowMapParams.z;
  float e = 0;
  for (int i=0; i<4; i++)
  {
    e += step(DecodeFloat(tex2D(Sampler_ShadowTexture, uv + filterTaps[i])) + Bias, DepthInLight);
  }
  e /= 4;
  return e;
}

//------------------------------------------------------------------------------------------------------------
#else // #ifdef INGAME
// Do nothing in 3dsmax
float3 GetShadowParams(float4 WorldPos) { return float3(0,0,0); }
float GetShadow(float3 ShadowMapParams, float Bias=0.005f) { return 0.f; }
float GetShadowFast(float3 ShadowMapParams, float Bias=0.005f) { return 0.f; }

#endif // #ifdef INGAME

//------------------------------------------------------------------------------------------------------------
// COMMON FUNCS
//------------------------------------------------------------------------------------------------------------

float GetInvSqr(float x) { return 1 - (1-x) * (1-x); }

float GetSqr(float x) { return x*x; }


#endif


/*
float3 AmbientLight = float3(0.5f,0.5f,0.5f);

void SolveVertexLight(
  in float4 WorldPos, in float3 WorldNormal, 
  out float3 DirectLight, out float3 ShadowParams
) {
  float3 LightColor = float3(1,1,1);
  
  DirectLight = saturate(WorldNormal.y)*LightColor;
  ShadowParams = GetShadowParams(WorldPos);
}

float4 SolvePixelLight(
  in float4 DiffuseColor,
  in float3 DirectLight, in float3 ShadowParams
) {
  float Shadow = GetShadow(ShadowParams);
  float3 Light = saturate(Shadow * DirectLight + AmbientLight);
  return float4(Light,1) * DiffuseColor;
}
*/

texture Tex0 : DiffuseMap
<
  int MapChannel = 1;
  string UIName = "Diffuse";
>;

sampler2D Sampler_Tex0 = sampler_state
{
  Texture = <Tex0>;
  AddressU = Clamp;
  AddressV = Clamp;
  MinFilter = Linear;
  MagFilter = Linear;
  MipFilter = Linear;
};

float4 Info
<
  string UIName = "Info";
> = float4(0,0,0,0);

#define Info_TextureWidth Info.x
#define Info_TextureHeight Info.y
#define Info_OutlineWidth Info.z

//------------------------------------------------------------------------------------------------------------
struct TVsOutFont
{
  float4 Pos : POSITION;
  float4 Color : COLOR0;
  float4 ChannelMask : COLOR1;
  float2 TexCoord : TEXCOORD0;
};

//------------------------------------------------------------------------------------------------------------
struct TPsInFont
{
  float4 Color : COLOR0;
  float4 ChannelMask : COLOR1;
  float2 TexCoord : TEXCOORD0;  
};

//------------------------------------------------------------------------------------------------------------
TVsOutFont VsMain(TVsInNoNormal IN)
{
  TVsOutFont OUT;
  OUT.Pos = mul(IN.Pos, WorldViewProjectionMatrix);
  OUT.Color = IN.Color;

  float Channel;
  OUT.TexCoord.x = modf(IN.TexCoord.x, Channel) + fmod(Channel, 2);
  OUT.TexCoord.y = IN.TexCoord.y;

  float4 ChannelMask = float4(step(Channel, 1), step(Channel, 3), step(Channel, 5), step(Channel, 7));
  OUT.ChannelMask.r = all(ChannelMask);
  OUT.ChannelMask.g = all(ChannelMask.gba) && !any(ChannelMask.r);
  OUT.ChannelMask.b = all(ChannelMask.ba) && !any(ChannelMask.rg);
  OUT.ChannelMask.a = all(ChannelMask.a) && !any(ChannelMask.rgb);
  return OUT;
}

//------------------------------------------------------------------------------------------------------------
float4 PsMain(TPsInFont IN) : COLOR0
{
  float StepX = Info_OutlineWidth / Info_TextureWidth;
  float StepY = Info_OutlineWidth / Info_TextureHeight;
  float2 CurrentCoord = IN.TexCoord;
  float4 ColorSum = tex2D(Sampler_Tex0, IN.TexCoord);
  float ChannelColor = dot(ColorSum, IN.ChannelMask);

  if (Info_OutlineWidth == 0)
  {
    float4 Color;
    Color.rgb = IN.Color.rgb;
    Color.a = IN.Color.a * ChannelColor;
    //Color.a *= step(0.35f, ChannelColor);
    return Color;
  }
  else
  {
    // Left
    CurrentCoord.x = IN.TexCoord.x - StepX;
    ColorSum += tex2D(Sampler_Tex0, CurrentCoord);
    // Right
    CurrentCoord.x = IN.TexCoord.x + StepX;
    ColorSum += tex2D(Sampler_Tex0, CurrentCoord);
    // Up Right
    CurrentCoord.y = IN.TexCoord.y - StepY;
    ColorSum += tex2D(Sampler_Tex0, CurrentCoord);
    // Up
    CurrentCoord.x = IN.TexCoord.x;
    ColorSum += tex2D(Sampler_Tex0, CurrentCoord);
    // Up Left
    CurrentCoord.x = IN.TexCoord.x - StepX;
    ColorSum += tex2D(Sampler_Tex0, CurrentCoord);
    // Down Left
    CurrentCoord.y = IN.TexCoord.y + StepY;
    ColorSum += tex2D(Sampler_Tex0, CurrentCoord);
    // Down
    CurrentCoord.x = IN.TexCoord.x;
    ColorSum += tex2D(Sampler_Tex0, CurrentCoord);
    // Down Right
    CurrentCoord.x = IN.TexCoord.x + StepX;
    ColorSum += tex2D(Sampler_Tex0, CurrentCoord);

    float Alpha = saturate(dot(ColorSum, IN.ChannelMask));
    float OutlineColorValue = step(max(max(IN.Color.r, IN.Color.g), IN.Color.b), 0.5);

    float4 OutlineColor = float4(OutlineColorValue, OutlineColorValue, OutlineColorValue, Alpha);
    float4 Color = ChannelColor * IN.Color + (Alpha - ChannelColor) * OutlineColor;
    return Color;
  }
}

//------------------------------------------------------------------------------------------------------------
technique Default
{
  pass p0
  {
    VertexShader = compile vs_2_0 VsMain();
    PixelShader  = compile ps_2_0 PsMain();    
    ALPHABLENDENABLE = TRUE;
    SRCBLEND = SRCALPHA;
    DESTBLEND = INVSRCALPHA;
    ZENABLE  = FALSE;
  }
}

