#ifndef _INC_FX
#define _INC_FX

//------------------------------------------------------------------------------------------------------------
// VSIN
//------------------------------------------------------------------------------------------------------------
#ifdef INGAME
  // ingame
  struct TVsInStd
  {
    float4 Pos : POSITION;
    float3 Normal : NORMAL;
    float4 Color : COLOR0;
    float2 TexCoord : TEXCOORD0;
  };

  #define UP y
  #define FORWARD z

#else

  // 3dsmax
  const bool RowMajor = true;
  const int texcoord0 : Texcoord 
  < int Texcoord = 0; int MapChannel = 0; bool ColorChannel = true; >;
  const int texcoord1 : Texcoord 
  < int Texcoord = 1; int MapChannel = 1; >;

  struct TVsInStd
  {
    float4 Pos : POSITION;
    float3 Normal : NORMAL;
    float4 Color : TEXCOORD0;
    float2 TexCoord : TEXCOORD1;
  };
  
  #define UP z
  #define FORWARD y

#endif

struct TVsInNoNormal
{
  float4 Pos : POSITION;
  float4 Color : COLOR0;
  float2 TexCoord : TEXCOORD0;
};

struct TVsInPosOnly
{
  float4 Pos : POSITION;
};

//------------------------------------------------------------------------------------------------------------
// VSOUT
//------------------------------------------------------------------------------------------------------------
struct TVsOutStd
{
  float4 Pos : POSITION;
  float4 Color: COLOR0;
  float2 TexCoord : TEXCOORD0;
};

struct TVsOutStdShadow
{
  float4 Pos : POSITION;
  float4 Color: COLOR0;
  float2 TexCoord : TEXCOORD0;
  float3 ShadowParams : TEXCOORD1;  
};

struct TPsInStdShadow
{
  float4 Color: COLOR0;
  float2 TexCoord : TEXCOORD0;
  float3 ShadowParams : TEXCOORD1;  
};

//------------------------------------------------------------------------------------------------------------
// PSIN
//------------------------------------------------------------------------------------------------------------
struct TPsInStd
{
  float4 Color: COLOR0;
  float2 TexCoord : TEXCOORD0;
};

//------------------------------------------------------------------------------------------------------------
struct TPsOut
{
  float4 Color : COLOR0;
};

//------------------------------------------------------------------------------------------------------------
// Matrixes
//------------------------------------------------------------------------------------------------------------
float4x4 WorldMatrix : WORLD;
float4x4 WorldViewMatrix : WORLDVIEW;
float4x4 WorldViewProjectionMatrix : WORLDVIEWPROJECTION;
float3 WorldCameraPos : WORLDCAMERAPOSITION;
float4x4 ViewInverseMatrix : VIEWI;
float4x4 ViewProjectionMatrix : VIEWPROJECTION;

const float GAME_PI = 3.1415926535;

#define FALSE             0
#define TRUE              1

#define ZERO              1
#define ONE               2
#define SRCCOLOR          3
#define INVSRCCOLOR       4
#define SRCALPHA          5
#define INVSRCALPHA       6
#define DESTALPHA         7
#define INVDESTALPHA      8
#define DESTCOLOR         9
#define INVDESTCOLOR     10
#define SRCALPHASAT      11
#define BOTHSRCALPHA     12
#define BOTHINVSRCALPHA  13
#define BLENDFACTOR      14
#define INVBLENDFACTOR   15

#define NONE              1
#define CW                2
#define CCW               3

//------------------------------------------------------------------------------------------------------------
// From: http://www.gamedev.net/community/forums/topic.asp?topic_id=442138
// CAN NOT ENCODE 1.0!!!
float4 EncodeFloat(float fDist)
{
  // encode (fDist is the normalized distance):
  const float4 bitSh  = float4(   256*256*256, 256*256,   256,         1);
  const float4 bitMsk = float4(   0,      1.0/256.0,    1.0/256.0,    1.0/256.0);

  float4 comp;
  comp  = fDist * bitSh;
  comp  = frac(comp);
  comp  -= comp.xxyz * bitMsk;
  return comp;
}

//------------------------------------------------------------------------------------------------------------
// From: http://www.gamedev.net/community/forums/topic.asp?topic_id=442138
float DecodeFloat(float4 vec)
{
  const float4 bitShifts = float4(1.0/(256.0*256.0*256.0), 1.0/(256.0*256.0), 1.0/256.0, 1);
  return dot(vec.xyzw , bitShifts);
}

//------------------------------------------------------------------------------------------------------------
// SHADOW
//------------------------------------------------------------------------------------------------------------
#if INGAME

texture ShadowTexture
<
  string name = "White.tga";
>;

sampler2D Sampler_ShadowTexture = sampler_state
{
  Texture = <ShadowTexture>;
  AddressU = Clamp;
  AddressV = Clamp;
  MinFilter = Point;
  MagFilter = Point;
  MipFilter = Point;
};

float4x4 ShadowLightMatrixInv;

//------------------------------------------------------------------------------------------------------------
float3 GetShadowParams(float4 WorldPos)
{
  float3 ShadowParams;
  float4 PosInLight = mul(WorldPos, ShadowLightMatrixInv);
  ShadowParams.xy = float2(PosInLight.x, PosInLight.y) * float2(0.5, -0.5) + float2(0.5, 0.5);
  ShadowParams.z = PosInLight.z;
  return ShadowParams;
}

//------------------------------------------------------------------------------------------------------------
#define ShadowMapSize 1024.f
#define ShadowMapUvStep (2.f / ShadowMapSize)
#define NUMTAPS 9
const float2 filterTaps[NUMTAPS] = {
  {ShadowMapUvStep * -0.326212, ShadowMapUvStep * -0.405805},
  {ShadowMapUvStep * -0.840144, ShadowMapUvStep * -0.073580},
  {ShadowMapUvStep * -0.695914, ShadowMapUvStep * +0.457137},
  {ShadowMapUvStep * -0.203345, ShadowMapUvStep * +0.620716},
  {ShadowMapUvStep * +0.962340, ShadowMapUvStep * -0.194983},
  {ShadowMapUvStep * +0.473434, ShadowMapUvStep * -0.480026},
  {ShadowMapUvStep * +0.519456, ShadowMapUvStep * +0.767022},
  {ShadowMapUvStep * +0.185461, ShadowMapUvStep * -0.893124},
  {ShadowMapUvStep * +0.507431, ShadowMapUvStep * +0.064425},
};
 
//------------------------------------------------------------------------------------------------------------
float GetShadow(float3 ShadowMapParams, float Bias=0.007f)
{
  float2 uv = ShadowMapParams.xy;
  float DepthInLight = ShadowMapParams.z;
  float e = 0;
  for (int i=0; i<NUMTAPS; i++)
  {
    e += step(DecodeFloat(tex2D(Sampler_ShadowTexture, uv + filterTaps[i])) + Bias, DepthInLight);
  }
  e /= NUMTAPS;
  return e;
}

//------------------------------------------------------------------------------------------------------------
float GetShadowFast(float3 ShadowMapParams, float Bias=0.007f)
{
  float2 uv = ShadowMapParams.xy;
  float DepthInLight = ShadowMapParams.z;
  float e = 0;
  for (int i=0; i<4; i++)
  {
    e += step(DecodeFloat(tex2D(Sampler_ShadowTexture, uv + filterTaps[i])) + Bias, DepthInLight);
  }
  e /= 4;
  return e;
}

//------------------------------------------------------------------------------------------------------------
#else // #ifdef INGAME
// Do nothing in 3dsmax
float3 GetShadowParams(float4 WorldPos) { return float3(0,0,0); }
float GetShadow(float3 ShadowMapParams, float Bias=0.005f) { return 0.f; }
float GetShadowFast(float3 ShadowMapParams, float Bias=0.005f) { return 0.f; }

#endif // #ifdef INGAME

//------------------------------------------------------------------------------------------------------------
// COMMON FUNCS
//------------------------------------------------------------------------------------------------------------

float GetInvSqr(float x) { return 1 - (1-x) * (1-x); }

float GetSqr(float x) { return x*x; }


#endif


/*
float3 AmbientLight = float3(0.5f,0.5f,0.5f);

void SolveVertexLight(
  in float4 WorldPos, in float3 WorldNormal, 
  out float3 DirectLight, out float3 ShadowParams
) {
  float3 LightColor = float3(1,1,1);
  
  DirectLight = saturate(WorldNormal.y)*LightColor;
  ShadowParams = GetShadowParams(WorldPos);
}

float4 SolvePixelLight(
  in float4 DiffuseColor,
  in float3 DirectLight, in float3 ShadowParams
) {
  float Shadow = GetShadow(ShadowParams);
  float3 Light = saturate(Shadow * DirectLight + AmbientLight);
  return float4(Light,1) * DiffuseColor;
}
*/

//------------------------------------------------------------------------------------------------------------
texture Tex0 : DiffuseMap
<
  int MapChannel = 1;
  string UIName = "Color";
>;

sampler2D Sampler_Tex0 = sampler_state
{
  Texture = <Tex0>;
  AddressU = Clamp;
  AddressV = Clamp;
  MinFilter = Linear;
  MagFilter = Linear;
  MipFilter = Linear;
};

texture Tex1 : DiffuseMap
<
  int MapChannel = 1;
  string UIName = "Color";
>;

sampler2D Sampler_Tex1 = sampler_state
{
  Texture = <Tex1>;
  AddressU = Clamp;
  AddressV = Clamp;
  MinFilter = Linear;
  MagFilter = Linear;
  MipFilter = Linear;
};

//------------------------------------------------------------------------------------------------------------
TVsOutStd VsMain(TVsInStd IN)
{
  TVsOutStd OUT;
  OUT.Pos = mul(IN.Pos, WorldViewProjectionMatrix);
  OUT.TexCoord = IN.TexCoord;
  OUT.Color = IN.Color;
  return OUT;
}

/*
#define GrabPix(n,a) float3 n = tex2D(Sampler_Tex0,(a)).xyz;

float BlurAmount = 0.0025f;

float4 PsMain(TPsInStd IN) : COLOR0
{
  float2 t = IN.TexCoord;
  
  float2 ox = float2(BlurAmount,0.0);
  float2 oy = float2(0.0,BlurAmount);
  float2 ox2 = 2 * ox;
  float2 oy2 = 2 * oy;
  float2 PP = t - oy2;                     
  GrabPix(c00,PP-ox2)                     
  GrabPix(c01,PP-ox)                     
  GrabPix(c02,PP)                     
  GrabPix(c03,PP+ox)                     
  GrabPix(c04,PP+ox2)                     
  PP = t - oy;                     
  GrabPix(c10,PP-ox2)                     
  GrabPix(c11,PP-ox)                     
  GrabPix(c12,PP)                     
  GrabPix(c13,PP+ox)                     
  GrabPix(c14,PP+ox2)                     
  PP = t;                     
  GrabPix(c20,PP-ox2)                     
  GrabPix(c21,PP-ox)                     
  GrabPix(c22,PP)                     
  GrabPix(c23,PP+ox)                     
  GrabPix(c24,PP+ox2)                     
  float3 m00 = (c00+c01+c02 + c10+c11+c12 + c20+c21+c22)/9;
  float3 d = (c00 - m00); float v00 = dot(d,d); 
  d = (c01 - m00); v00 += dot(d,d);           
  d = (c02 - m00); v00 += dot(d,d);           
  d = (c10 - m00); v00 += dot(d,d);           
  d = (c11 - m00); v00 += dot(d,d);           
  d = (c12 - m00); v00 += dot(d,d);           
  d = (c20 - m00); v00 += dot(d,d);           
  d = (c21 - m00); v00 += dot(d,d);           
  d = (c12 - m00); v00 += dot(d,d);           
  float3 m01 = (c02+c03+c04 + c12+c13+c14 + c22+c23+c24)/9;
  d = (c02 - m01); float v01 = dot(d,d);       
  d = (c03 - m01); v01 += dot(d,d);           
  d = (c04 - m01); v01 += dot(d,d);           
  d = (c12 - m01); v01 += dot(d,d);           
  d = (c13 - m01); v01 += dot(d,d);           
  d = (c14 - m01); v01 += dot(d,d);           
  d = (c22 - m01); v01 += dot(d,d);           
  d = (c23 - m01); v01 += dot(d,d);           
  d = (c14 - m01); v01 += dot(d,d);           
  PP = t + oy;                     
  GrabPix(c30,PP-ox2)                     
  GrabPix(c31,PP-ox)                     
  GrabPix(c32,PP)                     
  GrabPix(c33,PP+ox)                     
  GrabPix(c34,PP+ox2)                     
  PP = t + oy;                     
  GrabPix(c40,PP-ox2)                     
  GrabPix(c41,PP-ox)                     
  GrabPix(c42,PP)                     
  GrabPix(c43,PP+ox)                     
  GrabPix(c44,PP+ox2)                     
  float3 m10 = (c20+c21+c22 + c30+c31+c32 + c40+c41+c42)/9;
  d = (c20 - m00); float v10 = dot(d,d);       
  d = (c21 - m00); v00 += dot(d,d);           
  d = (c22 - m00); v00 += dot(d,d);           
  d = (c30 - m00); v00 += dot(d,d);           
  d = (c31 - m00); v00 += dot(d,d);           
  d = (c32 - m00); v00 += dot(d,d);           
  d = (c40 - m00); v00 += dot(d,d);           
  d = (c41 - m00); v00 += dot(d,d);           
  d = (c42 - m00); v00 += dot(d,d);           
  float3 m11 = (c22+c23+c24 + c32+c33+c34 + c42+c43+c44)/9;
  d = (c22 - m01); float v11 = dot(d,d);       
  d = (c23 - m01); v01 += dot(d,d);           
  d = (c24 - m01); v01 += dot(d,d);           
  d = (c32 - m01); v01 += dot(d,d);           
  d = (c33 - m01); v01 += dot(d,d);           
  d = (c34 - m01); v01 += dot(d,d);           
  d = (c42 - m01); v01 += dot(d,d);           
  d = (c43 - m01); v01 += dot(d,d);           
  d = (c44 - m01); v01 += dot(d,d);           
  float3 result = m00;                     
  float rv = v00;                     
  if (v01 < rv) { result = m01; rv = v01; }   
  if (v10 < rv) { result = m10; rv = v10; }   
  if (v11 < rv) { result = m11; }             
  return float4(result,1);                     
}
*/

//------------------------------------------------------------------------------------------------------------
static const int g_cKernelSize = 5;

//static const float R0 = 1 / 1024.f;
//static const float R1 = 3 / 1024.f;
//static const float R2 = 2 / 1024.f;

static const float R = 2 / 1024.f;

#if 0

float2 TexelKernel[g_cKernelSize] =
{
    {-R1,  R1}, {-R0,  R1}, {R0,  R1}, {R1,  R1},
    {-R1,  R0}, {-R0,  R0}, {R0,  R0}, {R1,  R0},
    {-R1, -R0}, {-R0, -R0}, {R0, -R0}, {R1, -R0},
    {-R1, -R1}, {-R0, -R1}, {R0, -R1}, {R1, -R1},
};

#endif

#ifdef SMARTBLUR_X

float2 TexelKernel[g_cKernelSize] =
{
    //{-R1,  0}, {-R0,  0}, {R0,  0}, {R1,  0},
    //{-4*R,  0},  {-3*R,  0},  {-2*R,  0}, {-1*R,  0}, {1*R,  0}, {2*R,  0}, {3*R,  0}, {-4*R,  0}
    //{-2*R,  0}, {-1*R,  0}, {1*R,  0}, {2*R,  0}
    {-2*R,  0}, {-1*R,  0}, {0, 0}, {1*R,  0}, {2*R,  0}
};

#else

float2 TexelKernel[g_cKernelSize] =
{
/*
    {0,  R1},
    {0,  R0},
    {0, -R0},
    {0, -R1},
    */
    //{0,  4*R}, {0,  3*R}, {0,  2*R}, {0,  1*R}, {0, -1*R}, {0, -2*R}, {0, -3*R}, {0, -4*R},
    //{0,  2*R}, {0,  1*R}, {0, -1*R}, {0, -2*R}
    {0,  2*R}, {0,  1*R}, {0, 0}, {0, -1*R}, {0, -2*R}
};

#endif

float BlurWeights[g_cKernelSize] =
{
  //0.125/2, 0.875/2, 0.875/2, 0.125/2
  //0.25/2, 0.75/2, 0.75/2, 0.25/2
  0.25/3, 0.75/3, 1.00/3, 0.75/3, 0.25/3
  //0.50/2, 0.50/2, 0.50/2, 0.50/2
  //0.25/3, 0.50/3, 0.75/3, 0.75/3, 0.50/3, 0.25/3
  //0.25/5, 0.50/5, 0.75/5, 1.00/5, 1.00/5, 0.75/5, 0.50/5, 0.25/5
  //0.125/4, 0.25/4, 0.625/4, 1.00/4, 1.00/4, 0.625/4, 0.25/4, 0.125/4
  
  //0.006, 0.061, 0.242, 0.382, 0.242, 0.061, 0.006,
  //0.015625, 0.046875, 0.046875, 0.015625,
  //0.046875, 0.140625, 0.140625, 0.046875,
  //0.046875, 0.140625, 0.140625, 0.046875,
  //0.015625, 0.046875, 0.046875, 0.015625,
};

static const float Thresh = 0.0015f; 
  
float4 PsMain(TPsInStd IN) : COLOR0
{
  float2 DstTexCoord = IN.TexCoord;
  float Dst = tex2D(Sampler_Tex1, DstTexCoord).x;
  //float Radius = (lerp(4, 1, 1/(0.01f+Dst)));
  //float z = tex2D(Sampler_Tex1, DstTexCoord).x;
  //z = (1/z - 1) / (1/.001f);
  float Radius = 0.5;//(lerp(1, 1, z));
  //float Radius = 0.5f/Dst;
  
  float Accum = 0;
  for (int i = 0; i < g_cKernelSize; i++)
  {    
    float Src = tex2D(Sampler_Tex0, DstTexCoord + Radius * TexelKernel[i].xy).x;
    //Src = tex2D(Sampler_Tex1, float2(Src, 0)).x;
    //Accum += Src * BlurWeights[i];
    //float t = step(Dst, Src + Thresh);
    
    //float grad = tex2D(Sampler_Tex1, float2(Dst-Src, 0)).x;
    //Accum += lerp(Dst, Src, grad) * BlurWeights[i];
    
    //float t = step(Dst, Src + Thresh);
    //Accum += lerp(Dst, Src, t) * BlurWeights[i];
    Accum += Src * BlurWeights[i];
  }  
  //Accum /= g_cKernelSize;  
  return float4(Accum, Accum, Accum, 0);
}

/*
//------------------------------------------------------------------------------------------------------------
static const int g_cKernelSize = 7;

static const float S0 = 2;
static const float S1 = 4;
static const float S2 = 6;

#ifdef SMARTBLUR_X

float2 TexelKernel[g_cKernelSize] =
{
    { -S2 / 1024.f, 0 },
    { -S1 / 1024.f, 0 },
    { -S0 / 1024.f, 0 },
    {   0 / 1024.f, 0 },
    {  S0 / 1024.f, 0 },
    {  S1 / 1024.f, 0 },
    {  S2 / 1024.f, 0 },
};

#else

float2 TexelKernel[g_cKernelSize] =
{
    { 0, -S2 / 1024.f },
    { 0, -S1 / 1024.f },
    { 0, -S0 / 1024.f },
    { 0,   0 / 1024.f },
    { 0,  S0 / 1024.f },
    { 0,  S1 / 1024.f },
    { 0,  S2 / 1024.f },
};

#endif

static const float BlurWeights[g_cKernelSize] = 
{
    0.006,
    0.061,
    0.242,
    0.383,
    0.242,
    0.061,
    0.006,
};

static const float Thresh = 0.001f;
  
float4 PsMain(TPsInStd IN) : COLOR0
{
  float2 DstTexCoord = IN.TexCoord;
  float Dst = tex2D(Sampler_Tex0, DstTexCoord).x;
  
  float Accum = 0;
  for (int i = 0; i < g_cKernelSize; i++)
  {    
    float Src = tex2D(Sampler_Tex0, DstTexCoord + TexelKernel[i].xy).x;
    float t = step(Dst, Src + Thresh);
    Accum += lerp(Dst, Src, t) * BlurWeights[i];    
  }
  
  return float4(Accum, Accum, Accum, 0);
}
*/

//------------------------------------------------------------------------------------------------------------
technique Default
{
  pass p0
  {
    VertexShader = compile vs_2_0 VsMain();
    PixelShader  = compile ps_2_0 PsMain();    
    CULLMODE = None;    
  }
}
